/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_MOTF_API_
#define SPICE3_MOTF_API_

#include "rlTypes.h"

RL_C_API rlResult rlMotfQuadratureDecoderInitConfig(rlQuadratureDecoderConfig* config);
RL_C_API rlResult rlMotfQuadratureDecoderToStringConfig(const rlQuadratureDecoderConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlMotfQuadratureDecoderLoadConfig(rlHandle handle);
RL_C_API rlResult rlMotfQuadratureDecoderStoreConfig(rlHandle handle);
RL_C_API rlResult rlMotfQuadratureDecoderGetConfig(rlHandle handle, rlQuadratureDecoderConfig* config);
RL_C_API rlResult rlMotfQuadratureDecoderSetConfig(rlHandle handle, const rlQuadratureDecoderConfig* config);

RL_C_API rlResult rlMotfInitConfig(rlMotfConfig* config);
RL_C_API rlResult rlMotfToStringConfig(const rlMotfConfig* config, char* buffer, uint32_t bufferSize, uint32_t* stringLength);
RL_C_API rlResult rlMotfGetConfig(rlHandle handle, rlMotfConfig* config);
RL_C_API rlResult rlMotfSetConfig(rlHandle handle, const rlMotfConfig* config);
RL_C_API rlResult rlMotfLoadConfig(rlHandle handle);
RL_C_API rlResult rlMotfStoreConfig(rlHandle handle);

RL_C_API rlResult rlMotfConfigSetDirectionFromAngle(rlMotfConfig* config, double angle);

// DEPRECATED, use QuadratureDecoderModule.SimulateDecoder instead.
// RL_C_API rlResult rlMotfIsEncoderSimulated( rlHandle handle, int32_t encoderID, bool* isSimulated );
// DEPRECATED, use QuadratureDecoderModule.SimulateDecoder instead.
// RL_C_API rlResult rlMotfSimulateEncoder( rlHandle handle, int32_t encoderID, bool simulate );
// DEPRECATED, use QuadratureDecoderModule.SimulateSimulationAcceleration instead.
// RL_C_API rlResult rlMotfGetSimulationAcceleration( rlHandle handle, int32_t encoderID, double* acceleration );
// DEPRECATED, use QuadratureDecoderModule.SimulateSimulationSpeed instead.
// RL_C_API rlResult rlMotfGetSimulationSpeed( rlHandle handle, int32_t encoderID, double* speed );
// DEPRECATED, use QuadratureDecoderModule.SimulateSimulationSpeed instead.
// RL_C_API rlResult rlMotfSetSimulationSpeed( rlHandle handle, int32_t encoderID, double speed, double acceleration );

RL_C_API rlResult rlMotfQuadratureDecoderResetEncoderPosition(rlHandle handle, int32_t encoderID);
RL_C_API rlResult rlMotfQuadratureDecoderReadEncoderPosition(rlHandle handle, int32_t encoderID, int32_t* position);

RL_C_API rlResult rlMotfGetPendingParts(rlHandle handle, int32_t* out);

RL_C_API rlResult rlMotfResetState(rlHandle handle);

RL_C_API rlResult rlGetFactor1xSpeed(rlHandle handle, double* speed);
RL_C_API rlResult rlSetFactor1xSpeed(rlHandle handle, double speed);

#endif // SPICE3_MOTF_API_
